<style>
    @charset "utf-8";
/* CSS Document */

* {
  box-sizing: border-box;
}

	.dfg-width {
		width: 100%;
		max-width: 768px;
		margin: 0 auto;
		padding: 10px 10px 0 10px;
	}
	.dfg-container {
  		display: grid;
 	 	grid-template-columns: repeat(4, 1fr);
  		grid-auto-rows: repeat(4, 1fr);
  		gap: 10px;
		}
		.square {
			border-radius: 0;
		}
		.rounded {
			border-radius: 1em;
		}	
		.content{
			height: 100%;
			width: 100%;
			position: relative;
			overflow: hidden;
		}
		.content-video,
		.content-slider  {
    		width: 100%;
    		position: relative;
   	 		overflow: hidden;
		}
		.content-icon {
			display: flex;
		    height: 56.25%;
		    align-items: flex-end;
		    justify-content: center;
			}
		.content-title {
			display: flex;
		    height: 43.75%;
		    align-items: flex-end;
		    justify-content: center;
			}
		.item-image {
			width: 100%;
			max-width: 100%;
			height: 100%;    
			position: absolute;
			z-index: 1;
			top: 0;
			left: 0;
		}
		.item-slider,
		.item-video {
		}
		.item-link a,
		.item-link a {
			text-decoration: none;
		}
		.dfg-logo {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 4;
	  		grid-row: auto;
			}
			.item-logo-image {
				width: 100%;
				max-width: 748px;
				display: block;	
				}
				.item-logo-link {
				}
		.dfg-1col-1row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 1;
	  		grid-row: span 1;
			}
			.dfg-1col-1row:after {
	  			content: "";
	  			display: block;
				padding-bottom: 100%;
				}
		.dfg-1col-2row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 1;
	  		grid-row: span 2;
		}
		.dfg-1col-2row:after {
	  		content: "";
	  		display: block;
			padding-bottom: calc(200% + 10px);
			}
		.dfg-1col-3row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 1;
	  		grid-row: span 3;
		}
		.dfg-1col-3row:after {
	  		content: "";
	  		display: block;
			padding-bottom: calc(300% + 10px);;
			}
		.dfg-1col-4row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 1;
	  		grid-row: span 4;
		}
		.dfg-1col-4row:after {
	  		content: "";
	  		display: block;
			padding-bottom: calc(400% + 30px);
			}
		.dfg-2col-1row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 2;
	  		grid-row: span 1;
		}
		.dfg-2col-1row:after {
	  		content: "";
	  		display: block;
	  		padding-bottom: calc(50% - 5px);
			}
		.dfg-2col-2row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 2;
	  		grid-row: span 2;
			}
			.dfg-2col-2row:after {
	  			content: "";
	  			display: block;
	  			padding-bottom: 100%;
				}
		.dfg-2col-3row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 2;
	  		grid-row: span 3;
			}
			.dfg-2col-3row:after {
	  			content: "";
	  			display: block;
	  			padding-bottom: calc(150% + 5px);
				}
		.dfg-2col-4row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 2;
	  		grid-row: span 4;
			}
			.dfg-2row-4row:after {
	  			content: "";
	  			display: block;
	  			padding-bottom: calc(200% + 10px);
				}
		.dfg-3col-1row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 3;
	  		grid-row: span 1;
			}
			.dfg-3col-1row:after {
	  			content: "";
	  			display: block;
				padding-bottom: calc(33.333333333% - 6.66px);
				}
		.dfg-3col-2row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 3;
	  		grid-row: span 2;
			}
			.dfg-3col-2row:after {
	  			content: "";
	  			display: block;
				padding-bottom: calc(66.6666666666% - 3.33px);
				}
		.dfg-3col-3row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 3;
	  		grid-row: span 3;
			}
			.dfg-3col-3row:after {
	  			content: "";
	  			display: block;
				padding-bottom: 100%;
				}
		.dfg-3col-4row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 3;
	  		grid-row: span 4;
			}
			.dfg-3col-4row:after {
	  			content: "";
	  			display: block;
				padding-bottom: calc(133.3333333333% + 3.34px);
				}
		.dfg-4col-1row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 4;
	  		grid-row: span 1;
			}
			.dfg-4col-1row:after {
	  			content: "";
	  			display: block;
				padding-bottom: calc(25% - 7.5px);
				}
		.dfg-4col-2row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 4;
	  		grid-row: span 2;
			}
			.dfg-4col-2row:after {
	  			content: "";
	  			display: block;
				padding-bottom: calc(50% - 5px);
				}
		.dfg-4col-3row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 4;
	  		grid-row: span 3;
			}
			.dfg-4col-3row:after {
	  			content: "";
	  			display: block;
				padding-bottom: calc(75% - 2.5px);
				}
		.dfg-4col-4row {
			height: 100%;
	        display: flex;
	        align-items: center;
	        justify-content: center;
	  		grid-column: span 4;
	  		grid-row: span 3;
			}
			.dfg-4col-4row:after {
	  			content: "";
	  			display: block;
				padding-bottom: 100%;
				}
.embed-container { 
    position: relative; 
    padding-bottom: 56.25% !important;
    height: 0;
    overflow: hidden;
    max-width: 100%;
    height: auto;
    } 
    .embed-container iframe,
    .embed-container object,
    .embed-container embed { 
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
    }

@media (min-width: 320px) {
  .item-title {
	font-family: 'Open Sans', sans-serif;
	font-weight: 600;
	text-transform: uppercase;
	line-height: normal;
  	text-align: center;
    font-size: calc(0.875rem + ((1vw - 3.2px) * 1.7857));
    min-height: 0vw;
    z-index: 9999;
	padding-bottom: 5px;
	text-decoration: none;
  }
}
@media (min-width: 768px) {
  .item-title {
	font-family: 'Open Sans', sans-serif;
	font-weight: 600;
	text-transform: uppercase;
	line-height: normal;
  	text-align: center;
    font-size: 22px;
    z-index: 9999;
	padding-bottom: 5px;
	text-decoration: none;
  }
}
@media (min-width: 320px) {
  .item-icon {
	line-height: 0;
  	text-align: center; 
	font-size: calc(2.125rem + ((1vw - 3.2px) * 4.4643));
    min-height: 0vw;
    z-index: 9999;
  }
}
@media (min-width: 768px) {
  .item-icon {
	line-height: 0;
  	text-align: center;
    font-size: 54px;
    z-index: 9999;
  }
}
</style>

<?php 

 //start app output 
            echo '<div class="dfg-width">';
            echo '<div class="dfg-container">';
                foreach ($df_app_data as $df_app) {
                   //show only app with specific name
                    if ($df_app->df_app_name == $df_app_name) {
if ($df_app->app_btn_bkg_color4 == '') { 
    //single row button
    if ($df_app->app_btn_size == '1col-1row' || $df_app->app_btn_size == '2col-1row' || $df_app->app_btn_size == '3col-1row' || $df_app->app_btn_size == '4col-1row' ||  $df_app->app_btn_size == '1col-2row' || $df_app->app_btn_size == '2col-2row' || $df_app->app_btn_size == '3col-2row' || $df_app->app_btn_size == '4col-2row' || $df_app->app_btn_size == '1col-3row' ||  $df_app->app_btn_size == '2col-3row' || $df_app->app_btn_size == '3col-3row' || $df_app->app_btn_size == '4col-3row') {
           //button with icon
            if ($df_app->app_btn_image_upload == '' && $df_app->app_btn_icon != '') {           
            echo '<div class="dfg-'.$df_app->app_btn_size.' '.$df_app->app_btn_shape.'" style="background-color: '.$df_app->app_btn_bkg_color.';">
            <div class="content">
                <a class="item-link" href="'.$df_app->app_btn_link.'" title="'.$df_app->app_btn_link_alt_tag.'" target="'.$df_app->app_btn_link_target.'">
                <div class="content-icon">
                    <div class="item-icon" style="color: '.$df_app->app_btn_icon_color.';"><i class="'.$df_app->app_btn_icon_weight.' '.$df_app->app_btn_icon.'"></i></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app->app_btn_title_color.';">'.$df_app->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            }
         //button with image
         if ($df_app->app_btn_icon == '' && $df_app->app_btn_image_upload != '') {
            echo '<div class="dfg-'.$df_app->app_btn_size.' '.$df_app->app_btn_shape.'" style="background-color: '.$df_app->app_btn_bkg_color.';">
            <div class="content">
                <a class="item-link" href="'.$df_app->app_btn_link.'" title="'.$df_app->app_btn_link_alt_tag.'" target="'.$df_app->app_btn_link_target.'">
                <img class="item-image '.$df_app->app_btn_shape.'" alt="'.$df_app->app_btn_image_alt_tag.'" src="'.$df_app->app_btn_image_upload.'">
                <div class="content-icon">
                    <div class="item-icon"></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app->app_btn_title_color.';">'.$df_app->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            }
         //button with icon and image
          if ($df_app->app_btn_icon != '' && $df_app->app_btn_image_upload != '') {
            echo '<div class="dfg-'.$df_app->app_btn_size.' '.$df_app->app_btn_shape.'" style="background-color: '.$df_app->app_btn_bkg_color.';">
            <div class="content">
                <a class="item-link" href="'.$df_app->app_btn_link.'" title="'.$df_app->app_btn_link_alt_tag.'" target="'.$df_app->app_btn_link_target.'">
                <img class="item-image '.$df_app->app_btn_shape.'" alt="'.$df_app->app_btn_image_alt_tag.'" src="'.$df_app->app_btn_image_upload.'">
                <div class="content-icon">
                    <div class="item-icon" style="color: '.$df_app->app_btn_icon_color.';"><i class="'.$df_app->app_btn_icon_weight.' '.$df_app->app_btn_icon.'"></i></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app->app_btn_title_color.';">'.$df_app->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            }
        //button with no icon and no image
         if ($df_app->app_btn_icon == '' && $df_app->app_btn_image_upload == '') {
            echo '<div class="dfg-'.$df_app->app_btn_size.' '.$df_app->app_btn_shape.'" style="background-color: '.$df_app->app_btn_bkg_color.';">
            <div class="content">
                <a class="item-link" href="'.$df_app->app_btn_link.'" title="'.$df_app->app_btn_link_alt_tag.'" target="'.$df_app->app_btn_link_target.'">
                <div class="content-icon">
                    <div class="item-icon"></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app->app_btn_title_color.';">'.$df_app->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
         }
    }
}   
    
    
    
if ($df_app->app_btn_bkg_color4 != '') {     
    //single row button
    if ($df_app->app_btn_size == '1col-1row' || $df_app->app_btn_size == '2col-1row' || $df_app->app_btn_size == '3col-1row' || $df_app->app_btn_size == '4col-1row' ||  $df_app->app_btn_size == '1col-2row' || $df_app->app_btn_size == '2col-2row' || $df_app->app_btn_size == '3col-2row' || $df_app->app_btn_size == '4col-2row' || $df_app->app_btn_size == '1col-3row' ||  $df_app->app_btn_size == '2col-3row' || $df_app->app_btn_size == '3col-3row' || $df_app->app_btn_size == '4col-3row') {
           //button with icon
            if ($df_app->app_btn_image_upload == '' && $df_app->app_btn_icon != '') {           
            echo '<div class="dfg-'.$df_app->app_btn_size.' '.$df_app->app_btn_shape.'" style="background-color: '.$df_app->app_btn_bkg_color4.';">
            <div class="content">
                <a class="item-link" href="'.$df_app->app_btn_link.'" title="'.$df_app->app_btn_link_alt_tag.'" target="'.$df_app->app_btn_link_target.'">
                <div class="content-icon">
                    <div class="item-icon" style="color: '.$df_app->app_btn_icon_color.';"><i class="'.$df_app->app_btn_icon_weight.' '.$df_app->app_btn_icon.'"></i></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app->app_btn_title_color.';">'.$df_app->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';            }
         //button with image
         if ($df_app->app_btn_icon == '' && $df_app->app_btn_image_upload != '') {
            echo '<div class="dfg-'.$df_app->app_btn_size.' '.$df_app->app_btn_shape.'" style="background-color: '.$df_app->app_btn_bkg_color4.';">
            <div class="content">
                <a class="item-link" href="'.$df_app->app_btn_link.'" title="'.$df_app->app_btn_link_alt_tag.'" target="'.$df_app->app_btn_link_target.'">
                <img class="item-image '.$df_app->app_btn_shape.'" alt="'.$df_app->app_btn_image_alt_tag.'" src="'.$df_app->app_btn_image_upload.'">
                <div class="content-icon">
                    <div class="item-icon"></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app->app_btn_title_color.';">'.$df_app->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            }
         //button with icon and image
          if ($df_app->app_btn_icon != '' && $df_app->app_btn_image_upload != '') {
            echo '<div class="dfg-'.$df_app->app_btn_size.' '.$df_app->app_btn_shape.'" style="background-color: '.$df_app->app_btn_bkg_color4.';">
            <div class="content">
                <a class="item-link" href="'.$df_app->app_btn_link.'" title="'.$df_app->app_btn_link_alt_tag.'" target="'.$df_app->app_btn_link_target.'">
                <img class="item-image '.$df_app->app_btn_shape.'" alt="'.$df_app->app_btn_image_alt_tag.'" src="'.$df_app->app_btn_image_upload.'">
                <div class="content-icon">
                    <div class="item-icon" style="color: '.$df_app->app_btn_icon_color.';"><i class="'.$df_app->app_btn_icon_weight.' '.$df_app->app_btn_icon.'"></i></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app->app_btn_title_color.';">'.$df_app->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            }
        //button with no icon and no image
         if ($df_app->app_btn_icon == '' && $df_app->app_btn_image_upload == '') {
            echo '<div class="dfg-'.$df_app->app_btn_size.' '.$df_app->app_btn_shape.'" style="background-color: '.$df_app->app_btn_bkg_color4.';">
            <div class="content">
                <a class="item-link" href="'.$df_app->app_btn_link.'" title="'.$df_app->app_btn_link_alt_tag.'" target="'.$df_app->app_btn_link_target.'">
                <div class="content-icon">
                    <div class="item-icon"></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app->app_btn_title_color.';">'.$df_app->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
         }
    }           
}   
    


    //display logo
    if (  $df_app->app_btn_title == 'Logo') {
        //square logo element
         if ($df_app->app_btn_size == 'dfg-logo') {
             echo '
       <div class="'.$df_app->app_btn_size.'">
           <img class="item-logo-image '.$df_app->app_btn_shape.'" alt="'.$df_app->app_btn_image_alt_tag.'" src="'.$df_app->app_btn_image_upload.'">  
       </div>';
         }
        //rectangle and tall logo element
         if ($df_app->app_btn_size == 'dfg-2col-2row' || $df_app->app_btn_size == 'dfg-2col-3row' ) {
             echo '<div class="'.$df_app->app_btn_size.' '.$df_app->app_btn_shape.'">
            <div class="content">
                <img class="item-image '.$df_app->app_btn_shape.'" alt="'.$df_app->app_btn_image_alt_tag.'" src="'.$df_app->app_btn_image_upload.'">
                <div class="content-icon">
                    <div class="item-icon"></div>
                </div>
                <div class="content-title">
                    <div class="item-title"></div>
                </div>
            </div>
                </div>';
         }
    }
    
    //display Slider or Video
    if (  $df_app->app_btn_title == 'LayerSlider') {
        $df_ls_no = $df_app->app_btn_link;
        $oxy_slider =  '[oxygen-template id="'. $df_ls_no . '"]' ;
        echo '<div class="dfg-4col-2row">
            <div class="content-video">
                <div class="item-video">';
        echo $oxy_slider;
        echo '</div>
            </div>
       </div>';
    }    
    
    //display Vimeo Video element
    if ($df_app->app_btn_title == 'Vimeo Video') {
        $df_vimeo_video_sc = $df_app->app_btn_link;
        $oxy_vimeo =  '[oxygen-template id="'. $df_vimeo_video_sc . '"]' ;
            if ($df_app->app_btn_size == 'dfgv-video') {
                echo '<div class="dfg-4col-2row">
            <div class="content-video">
                <div class="embed-container">
                    <iframe src="https://player.vimeo.com/video/'.$df_vimeo_video_sc.'" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
                </div>
            </div>
            </div>';    
            }
            if ($df_app->app_btn_size == 'dfgv-2col-2row') {
                echo '<div class="dfg-2col-2row" style="background-color: #000000;">
            <div class="content-video">
                <div style="class="embed-container">
                    <iframe src="https://player.vimeo.com/video/'.$df_vimeo_video_sc.'" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
                </div>
            </div>
            </div>';
            }
}
            
        }
    }                 
                        
           //end app output
            echo '</div>';
            echo '</div>';
?>