<?php
/*
Plugin Name: DF App Builder
Plugin URI:  https://www.dentalfone.com/
Description: Build your app.
Version:     2.0
Author:      Dentalfone
Author URI:  https://www.dentalfone.com/
Text Domain: DF App Builder
*/

//add options page to wp admin
add_action('admin_menu', 'df_app_builder_create');
function df_app_builder_create() {
    $page_title = 'DF App Builder';
    $menu_title = 'DF App Builder';
    $capability = 'edit_posts';
    $menu_slug = 'df_app_builder';
    $function = 'df_app_builder_display';
    $icon_url = '/wp-content/plugins/df-app-builder/dashicon.png';
    $position = 24;

    add_menu_page( $page_title, $menu_title, $capability, $menu_slug, $function, $icon_url, $position );
}

//enqueue options page css and scripts
function df_app_builder_scripts($hook) {
    if ( 'toplevel_page_df_app_builder' != $hook ) {
        return;
    }
    wp_enqueue_style( 'df_app_builder_css', plugins_url('df-app-builder.css', __FILE__) );
    wp_enqueue_style( 'df_app_builder_css_font_awesome', plugins_url('/css/fontawesome.css', __FILE__) );
    wp_enqueue_style( 'df_app_builder_css_font_awesome_all', plugins_url('/css/all.css', __FILE__) );
    wp_enqueue_style( 'df_app_builder_css_font_awesome_brands', plugins_url('/css/brands.css', __FILE__) );
    wp_enqueue_style( 'df_app_builder_css_font_awesome_duotone', plugins_url('/css/duotone.css', __FILE__) );
    wp_enqueue_style( 'df_app_builder_css_font_awesome_light', plugins_url('/css/light.css', __FILE__) );
    wp_enqueue_style( 'df_app_builder_css_font_awesome_regular', plugins_url('/css/regular.css', __FILE__) );
    wp_enqueue_style( 'df_app_builder_css_font_awesome_solid', plugins_url('/css/solid.css', __FILE__) );
    wp_enqueue_style( 'df_app_builder_css_font_awesome_v4', plugins_url('/css/v4-shims.css', __FILE__) );
    wp_enqueue_script( 'df_app_builder_flowtype', plugins_url('flowtype.js', __FILE__) );
    wp_enqueue_script( 'df_app_builder_select2', plugins_url('select2.js', __FILE__) );
    wp_enqueue_style( 'df_app_builder_select2_css', plugins_url('select2.css', __FILE__) );
}
add_action( 'admin_enqueue_scripts', 'df_app_builder_scripts' );



//enqueue app builder font awesome css
function df_app_builder_font_awesome() {
    wp_enqueue_style( 'df_app_builder_font_awesome', plugins_url('/css/fontawesome.css', __FILE__) );

}
add_action( 'wp_enqueue_scripts', 'df_app_builder_font_awesome');

function df_app_builder_font_awesome_all() {
    wp_enqueue_style( 'df_app_builder_font_awesome_all', plugins_url('/css/all.css', __FILE__) );

}
add_action( 'wp_enqueue_scripts', 'df_app_builder_font_awesome_all');

function df_app_builder_font_awesome_brands() {
    wp_enqueue_style( 'df_app_builder_font_awesome_brands', plugins_url('/css/brands.css', __FILE__) );

}
add_action( 'wp_enqueue_scripts', 'df_app_builder_font_awesome_brands');

function df_app_builder_font_awesome_duotone() {
    wp_enqueue_style( 'df_app_builder_font_awesome_duotone', plugins_url('/css/duotone.css', __FILE__) );

}
add_action( 'wp_enqueue_scripts', 'df_app_builder_font_awesome_duotone');

function df_app_builder_font_awesome_light() {
    wp_enqueue_style( 'df_app_builder_font_awesome_light', plugins_url('/css/light.css', __FILE__) );

}
add_action( 'wp_enqueue_scripts', 'df_app_builder_font_awesome_light');

function df_app_builder_font_awesome_regular() {
    wp_enqueue_style( 'df_app_builder_font_awesome_regular', plugins_url('/css/regular.css', __FILE__) );

}
add_action( 'wp_enqueue_scripts', 'df_app_builder_font_awesome_regular');

function df_app_builder_font_awesome_solid() {
    wp_enqueue_style( 'df_app_builder_font_awesome_solid', plugins_url('/css/solid.css', __FILE__) );

}
add_action( 'wp_enqueue_scripts', 'df_app_builder_font_awesome_solid');

function df_app_builder_font_awesome_v4() {
    wp_enqueue_style( 'df_app_builder_font_awesome_v4', plugins_url('/css/v4-shims.css', __FILE__) );

}
add_action( 'wp_enqueue_scripts', 'df_app_builder_font_awesome_v4');


//enque wordpress media library
function my_enqueue_media_lib_uploader() {
    //Core media script
    wp_enqueue_media();
}
add_action('admin_enqueue_scripts', 'my_enqueue_media_lib_uploader');


//enqueue flowtype settings to site footer
function add_flowtype_script() {
      echo "<script>jQuery('.dfg-container').flowtype({
            maxFont: 24,
            minFont: 10
        });</script>\n";
    }
add_action( 'wp_footer', 'add_flowtype_script', 25 );


//Add a custom shortcode for displaying an Oxygen template or reusable part. Sample usage: [oxygen-template id="478"]. https://wpdevdesign.com/shortcode-for-displaying-oxygen-templates-and-reusable-parts/ 
add_shortcode( 'oxygen-template', 'func_oxygen_template' );
function func_oxygen_template( $atts ) {
return do_shortcode( get_post_meta( $atts['id'], 'ct_builder_shortcodes', true ) );
}


//create custom table in db to store app data
function df_app_builder_create_db() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

    $tablename = $wpdb->prefix.'df_app_builder';
    $sql = "CREATE TABLE $tablename (
    app_id INTEGER NOT NULL AUTO_INCREMENT,
    df_app_name TEXT NOT NULL,
    app_btn_size TEXT,
    app_btn_position TEXT,
    app_btn_bkg_color TEXT,
    app_btn_bkg_color1 TEXT,
    app_btn_bkg_color2 TEXT,
    app_btn_bkg_color3 TEXT,
    app_btn_bkg_color4 TEXT,
    app_btn_shape TEXT,
    app_btn_title TEXT,
    app_btn_title_color TEXT,
    app_btn_icon TEXT,
    app_btn_icon_weight TEXT,
    app_btn_icon_color TEXT,
    app_btn_image_upload TEXT,
    app_btn_image_alt_tag TEXT,
    app_btn_link TEXT,
    app_btn_link_alt_tag TEXT,
    app_btn_link_target TEXT,
    df_app_oxy TEXT,
    df_drag_id TEXT,
    df_drag_name TEXT,
    df_drag_size TEXT,
    df_drag_position TEXT,
    df_drag_bkg_color TEXT,
    df_drag_bkg_color1 TEXT,
    df_drag_bkg_color2 TEXT,
    df_drag_bkg_color3 TEXT,
    df_drag_bkg_color4 TEXT,
    df_drag_shape TEXT,
    df_drag_title_color TEXT,
    df_drag_icon TEXT,
    df_drag_icon_weight TEXT,
    df_drag_icon_color TEXT,
    df_drag_image_upload TEXT,
    df_drag_image_alt_tag TEXT,
    df_drag_link TEXT,
    df_drag_link_alt_tag TEXT,
    df_drag_link_target TEXT,
    drag_oxy TEXT,
    PRIMARY KEY (app_id)
    ) $charset_collate;";
    dbDelta( $sql );
}
register_activation_hook( __FILE__, 'df_app_builder_create_db' );


//if columns dont exist add them
$row = $wpdb->get_results(  "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS
WHERE table_name = 'dfk2_df_app_builder' AND column_name = 'df_app_oxy,df_drag_id,df_drag_name,df_drag_size,df_drag_position,df_drag_bkg_color,df_drag_bkg_color1,df_drag_bkg_color2,df_drag_bkg_color3,df_drag_bkg_color4,df_drag_shape,df_drag_title_color,df_drag_icon,df_drag_icon_weight,df_drag_icon_color,df_drag_image_upload,df_drag_image_alt_tag,df_drag_link,df_drag_link_alt_tag,df_drag_link_target'"  );

if(empty($row)){
   $wpdb->query("ALTER TABLE dfk2_df_app_builder
  ADD (df_app_oxy TEXT,
    df_drag_id TEXT,
    df_drag_name TEXT,
    df_drag_size TEXT,
    df_drag_position TEXT,
    df_drag_bkg_color TEXT,
    df_drag_bkg_color1 TEXT,
    df_drag_bkg_color2 TEXT,
    df_drag_bkg_color3 TEXT,
    df_drag_bkg_color4 TEXT,
    df_drag_shape TEXT,
    df_drag_title_color TEXT,
    df_drag_icon TEXT,
    df_drag_icon_weight TEXT,
    df_drag_icon_color TEXT,
    df_drag_image_upload TEXT,
    df_drag_image_alt_tag TEXT,
    df_drag_link TEXT,
    df_drag_link_alt_tag TEXT,
    df_drag_link_target TEXT,
    drag_oxy TEXT)");
}

//add app data to custom table in db from form input
if ( isset( $_POST['df_app_data'] ) ){
    //$df_app_data = (string) $_POST['df_app_data'];
	
    global $wpdb;
	$tablename = $wpdb->prefix.'df_app_builder';

	$wpdb->insert( $tablename, array(
		'app_id' => $_POST['app_id'], 
		'df_app_name' => $_POST['df_app_name'],
		'df_app_oxy' => $_POST['df_app_oxy'],
		'df_drag_id' => $_POST['df_drag_id'],
		'df_drag_name' => $_POST['df_drag_name'],
		'app_btn_size' => $_POST['app_btn_size'], 
		'app_btn_position' => $_POST['app_btn_position'],
		'app_btn_bkg_color' => $_POST['app_btn_bkg_color'],
		'app_btn_bkg_color1' => $_POST['app_btn_bkg_color1'],
		'app_btn_bkg_color2' => $_POST['app_btn_bkg_color2'],
		'app_btn_bkg_color3' => $_POST['app_btn_bkg_color3'],
		'app_btn_bkg_color4' => $_POST['app_btn_bkg_color4'],
		'app_btn_shape' => $_POST['app_btn_shape'], 
		'app_btn_title' => $_POST['app_btn_title'], 
		'app_btn_title_color' => $_POST['app_btn_title_color'], 
		'app_btn_icon' => $_POST['app_btn_icon'], 
		'app_btn_icon_weight' => $_POST['app_btn_icon_weight'], 
		'app_btn_icon_color' => $_POST['app_btn_icon_color'], 
		'app_btn_image_upload' => $_POST['app_btn_image_upload'], 
		'app_btn_image_alt_tag' => $_POST['app_btn_image_alt_tag'], 
		'app_btn_link' => $_POST['app_btn_link'],
		'app_btn_link_alt_tag' => $_POST['app_btn_link_alt_tag'],
		'app_btn_link_target' => $_POST['app_btn_link_target'],
		'drag_oxy' => $_POST['drag_oxy'],
		'df_drag_size' => $_POST['df_drag_size'], 
		'df_drag_position' => $_POST['df_drag_position'],
		'df_drag_bkg_color' => $_POST['df_drag_bkg_color'],
		'df_drag_bkg_color1' => $_POST['df_drag_bkg_color1'],
		'df_drag_bkg_color2' => $_POST['df_drag_bkg_color2'],
		'df_drag_bkg_color3' => $_POST['df_drag_bkg_color3'],
		'df_drag_bkg_color4' => $_POST['df_drag_bkg_color4'],
		'df_drag_shape' => $_POST['df_drag_shape'], 
		'df_drag_title_color' => $_POST['df_drag_title_color'], 
		'df_drag_icon' => $_POST['df_drag_icon'], 
		'df_drag_icon_weight' => $_POST['df_drag_icon_weight'], 
		'df_drag_icon_color' => $_POST['df_drag_icon_color'], 
		'df_drag_image_upload' => $_POST['df_drag_image_upload'], 
		'df_drag_image_alt_tag' => $_POST['df_drag_image_alt_tag'], 
		'df_drag_link' => $_POST['df_drag_link'],
		'df_drag_link_alt_tag' => $_POST['df_drag_link_alt_tag'],
		'df_drag_link_target' => $_POST['df_drag_link_target'] ),  
		array( '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s' ) 
	);
}

//display options page form input values
function df_app_builder_display() {  
	
	//process option form input values
	$app_id = 'app_id';
	$df_app_name = 'df_app_name';
	$df_app_oxy = 'df_app_oxy';
	$df_drag_id = 'df_drag_id';
	$df_drag_name = 'df_drag_name';
	$btn_size = 'btn_size';
	$btn_position = 'btn_position';
	$btn_bkg_color = 'btn_bkg_color';
	$btn_bkg_color1 = 'btn_bkg_color1';
	$btn_bkg_color2 = 'btn_bkg_color2';
	$btn_bkg_color3 = 'btn_bkg_color3';
	$btn_bkg_color4 = 'btn_bkg_color4';
	$btn_shape = 'btn_shape';
	$btn_title = 'btn_title';
	$btn_title_color = 'btn_title_color';
	$btn_icon = 'btn_icon';
	$btn_icon_weight = 'btn_icon_weight';
	$btn_icon_color = 'btn_icon_color';
	$btn_image_upload = 'btn_image_upload';
	$btn_image_alt_tag = 'btn_image_alt_tag';
	$btn_link = 'btn_link';
	$btn_link_alt_tag = 'btn_link_alt_tag';
	$btn_link_target = 'btn_link_target';
	$df_rename_app = 'df_rename_app';
	$drag_oxy = 'drag_oxy';
	$drag_size = 'drag_size';
	$drag_position = 'drag_position';
	$drag_bkg_color = 'drag_bkg_color';
	$drag_bkg_color1 = 'drag_bkg_color1';
	$drag_bkg_color2 = 'drag_bkg_color2';
	$drag_bkg_color3 = 'drag_bkg_color3';
	$drag_bkg_color4 = 'drag_bkg_color4';
	$drag_shape = 'drag_shape';
	$drag_title_color = 'drag_title_color';
	$drag_icon = 'drag_icon';
	$drag_icon_weight = 'drag_icon_weight';
	$drag_icon_color = 'drag_icon_color';
	$drag_image_upload = 'drag_image_upload';
	$drag_image_alt_tag = 'drag_image_alt_tag';
	$drag_link = 'drag_link';
	$drag_link_alt_tag = 'drag_link_alt_tag';
	$drag_link_target = 'drag_link_target';
	$drag_rename_app = 'drag_rename_app';

	//if option form input values exist, update them
	if (isset($_POST[$app_id]) || isset($_POST[$df_app_name]) || isset($_POST[$df_app_oxy]) || isset($_POST[$df_drag_id]) || isset($_POST[$df_drag_name]) || isset($_POST[$df_rename_app]) || isset($_POST[$btn_bkg_color]) || isset($_POST[$btn_bkg_color1]) || isset($_POST[$btn_bkg_color2]) || isset($_POST[$btn_bkg_color3]) || isset($_POST[$btn_bkg_color4]) || isset($_POST[$btn_size]) || isset($_POST[$btn_position]) || isset($_POST[$btn_shape]) || isset($_POST[$btn_title]) || isset($_POST[$btn_title_color]) || isset($_POST[$btn_icon]) || isset($_POST[$btn_icon_weight]) || isset($_POST[$btn_icon_color]) || isset($_POST[$btn_image_upload]) || isset($_POST[$btn_image_alt_tag]) || isset($_POST[$btn_link]) || isset($_POST[$btn_link_alt_tag]) || isset($_POST[$btn_link_target]) || isset($_POST[$drag_oxy]) || isset($_POST[$drag_size]) || isset($_POST[$drag_position]) || isset($_POST[$drag_bkg_color]) || isset($_POST[$drag_bkg_color1]) || isset($_POST[$drag_bkg_color2]) || isset($_POST[$drag_bkg_color3]) || isset($_POST[$drag_bkg_color4]) || isset($_POST[$drag_shape]) || isset($_POST[$drag_title_color])  | isset($_POST[$drag_icon]) || isset($_POST[$drag_icon_weight]) || isset($_POST[$drag_icon_color]) || isset($_POST[$drag_image_upload]) || isset($_POST[$drag_image_alt_tag]) || isset($_POST[$drag_link]) || isset($_POST[$drag_tink_alt_tag]) || isset($_POST[$drag_link_target]) || isset($_POST[$drag_rename_app]) )  {   
        update_option($app_id, $_POST[$app_id]);      
        update_option($df_app_name, $_POST[$df_app_name]);  
        update_option($df_app_oxy, $_POST[$df_app_oxy]);    
        update_option($df_drag_id, $_POST[$df_drag_id]);   
        update_option($df_drag_name, $_POST[$df_drag_name]);
        update_option($btn_size, $_POST[$btn_size]); 
        update_option($btn_position, $_POST[$btn_position]); 
        update_option($btn_bkg_color, $_POST[$btn_bkg_color]); 
        update_option($btn_bkg_color1, $_POST[$btn_bkg_color1]); 
        update_option($btn_bkg_color2, $_POST[$btn_bkg_color2]); 
        update_option($btn_bkg_color3, $_POST[$btn_bkg_color3]); 
        update_option($btn_bkg_color4, $_POST[$btn_bkg_color4]); 
        update_option($btn_shape, $_POST[$btn_shape]);     
        update_option($btn_title, $_POST[$btn_title]);     
        update_option($btn_title_color, $_POST[$btn_title_color]);   
        update_option($btn_icon, $_POST[$btn_icon]);     
        update_option($btn_icon_weight, $_POST[$btn_icon_weight]);      
        update_option($btn_icon_color, $_POST[$btn_icon_color]);  
        update_option($btn_image_upload, $_POST[$btn_image_upload]);     
        update_option($btn_image_alt_tag, $_POST[$btn_image_alt_tag]);     
        update_option($btn_link, $_POST[$btn_link]);       
        update_option($btn_link_alt_tag, $_POST[$btn_link_alt_tag]);    
        update_option($btn_link_target, $_POST[$btn_link_target]);
        update_option($df_rename_app, $_POST[$df_rename_app]); 
        update_option($drag_oxy, $_POST[$drag_oxy]);    
        update_option($drag_size, $_POST[$drag_size]); 
        update_option($drag_position, $_POST[$drag_position]); 
        update_option($drag_bkg_color, $_POST[$drag_bkg_color]); 
        update_option($drag_bkg_color1, $_POST[$drag_bkg_color1]); 
        update_option($drag_bkg_color2, $_POST[$drag_bkg_color2]); 
        update_option($drag_bkg_color3, $_POST[$drag_bkg_color3]); 
        update_option($drag_bkg_color4, $_POST[$drag_bkg_color4]); 
        update_option($drag_shape, $_POST[$drag_shape]);     
        update_option($drag_title_color, $_POST[$drag_title_color]);   
        update_option($drag_icon, $_POST[$drag_icon]);     
        update_option($drag_icon_weight, $_POST[$drag_icon_weight]);      
        update_option($drag_icon_color, $_POST[$drag_icon_color]);  
        update_option($drag_image_upload, $_POST[$drag_image_upload]);     
        update_option($drag_image_alt_tag, $_POST[$drag_image_alt_tag]);     
        update_option($drag_link, $_POST[$drag_link]);       
        update_option($drag_link_alt_tag, $_POST[$drag_link_alt_tag]);    
        update_option($drag_link_target, $_POST[$drag_link_target]);
        update_option($drag_rename_app, $_POST[$drag_rename_app]); 
    }	

	//get option form input values
	$app_id = get_option($app_id, $_POST[$app_id]);
	$df_app_name = get_option($df_app_name, $_POST[$df_app_name]);
	$df_app_oxy = get_option($df_app_oxy, $_POST[$df_app_oxy]);
	$df_drag_id = get_option($df_drag_id, $_POST[$df_drag_id]);
	$df_drag_name = get_option($df_drag_name, $_POST[$df_drag_name]);
	$btn_size = get_option($btn_size, $_POST[$btn_size]);
	$btn_position = get_option($btn_position, $_POST[$btn_position]);
	$btn_bkg_color = get_option($btn_bkg_color, $_POST[$btn_bkg_color]);
	$btn_bkg_color1 = get_option($btn_bkg_color1, $_POST[$btn_bkg_color1]);
	$btn_bkg_color2 = get_option($btn_bkg_color2, $_POST[$btn_bkg_color2]);
	$btn_bkg_color3 = get_option($btn_bkg_color3, $_POST[$btn_bkg_color3]);
	$btn_bkg_color4 = get_option($btn_bkg_color4, $_POST[$btn_bkg_color4]);
	$btn_shape = get_option($btn_shape, $_POST[$btn_shape]);
	$btn_title = get_option($btn_title, $_POST[$btn_title]);
	$btn_title_color = get_option($btn_title_color, $_POST[$btn_title_color]);
	$btn_icon = get_option($btn_icon, $_POST[$btn_icon]);
	$btn_icon_weight = get_option($btn_icon_weight, $_POST[$btn_icon_weight]);
	$btn_icon_color = get_option($btn_icon_color, $_POST[$btn_icon_color]);
	$btn_image_upload = get_option($btn_image_upload, $_POST[$btn_image_upload]);
	$btn_image_alt_tag = get_option($btn_image_alt_tag, $_POST[$btn_image_alt_tag]);
	$btn_link = get_option($btn_link, $_POST[$btn_link]);
	$btn_link_alt_tag = get_option($btn_link_alt_tag, $_POST[$btn_link_alt_tag]);
	$btn_link_target = get_option($btn_link_target, $_POST[$btn_link_target]);
	$df_rename_app = get_option($df_rename_app, $_POST[$df_rename_app]);
	$drag_oxy = get_option($drag_oxy, $_POST[$drag_oxy]);
	$drag_size = get_option($drag_size, $_POST[$drag_size]);
	$drag_position = get_option($drag_position, $_POST[$drag_position]);
	$drag_bkg_color = get_option($drag_bkg_color, $_POST[$drag_bkg_color]);
	$drag_bkg_color1 = get_option($drag_bkg_color1, $_POST[$drag_bkg_color1]);
	$drag_bkg_color2 = get_option($drag_bkg_color2, $_POST[$drag_bkg_color2]);
	$drag_bkg_color3 = get_option($drag_bkg_color3, $_POST[$drag_bkg_color3]);
	$drag_bkg_color4 = get_option($drag_bkg_color4, $_POST[$drag_bkg_color4]);
	$drag_shape = get_option($drag_shape, $_POST[$drag_shape]);
	$drag_title_color = get_option($drag_title_color, $_POST[$drag_title_color]);
	$drag_icon = get_option($drag_icon, $_POST[$drag_icon]);
	$drag_icon_weight = get_option($drag_icon_weight, $_POST[$drag_icon_weight]);
	$drag_icon_color = get_option($drag_icon_color, $_POST[$drag_icon_color]);
	$drag_image_upload = get_option($drag_image_upload, $_POST[$drag_image_upload]);
	$drag_image_alt_tag = get_option($drag_image_alt_tag, $_POST[$drag_image_alt_tag]);
	$drag_link = get_option($drag_link, $_POST[$drag_link]);
	$drag_link_alt_tag = get_option($drag_link_alt_tag, $_POST[$drag_link_alt_tag]);
	$drag_link_target = get_option($drag_link_target, $_POST[$drag_link_target]);
	$drag_rename_app = get_option($drag_rename_app, $_POST[$drag_rename_app]);
	
	//display form on options page
    include 'df-app-builder-form.php';
}

//retrieve all app data from custom table in db and display data with specific app name with a shortcode
function df_app_builder_output_sc( $atts ) {
	global $wpdb;
	$tablename = $wpdb->prefix.'df_app_builder';
	$df_app_sc_data = $wpdb->get_results( "SELECT * FROM $tablename ORDER BY app_id" );  
	if (!isset($atts['name'])) $atts['name'] = '';

		   //start app output 
		    echo '<div class="dfg-width">';
		    echo '<div class="dfg-container">';


	foreach ($df_app_sc_data as $df_app_sc) {
		if ( $atts['name'] == $df_app_sc->df_app_name) {


if ($df_app_sc->app_btn_bkg_color4 == '') { 
	//single row button
	if ($df_app_sc->app_btn_size == '1col-1row' || $df_app_sc->app_btn_size == '2col-1row' || $df_app_sc->app_btn_size == '3col-1row' || $df_app_sc->app_btn_size == '4col-1row' || $df_app_sc->app_btn_size == '4col-2row' || $df_app_sc->app_btn_size == '4col-3row') {
		   //button with icon and no alignment
		    if ($df_app_sc->app_btn_image_upload == '' && $df_app_sc->app_btn_icon != '' && $df_app_sc->df_app_oxy == 'No') {    		
			$df_app_sc_output1 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.'" style="background: '.$df_app_sc->app_btn_bkg_color.';">
                    <div title="'.$df_app_sc->app_btn_title.'" class="dfg-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
            echo $df_app_sc_output1;
		    }
		 //button with image and no alignment 
		 if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output2 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.'" style="background: '.$df_app_sc->app_btn_bkg_color.';">
                    <img alt="'.$df_app_sc->app_btn_image_alt_tag.'" class="'.$df_app_sc->app_btn_shape.'" src="'.$df_app_sc->app_btn_image_upload.'" />
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output2;
		    }
		 //button with icon and image and no alignment
		  if ($df_app_sc->app_btn_icon != '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output3 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.'" style="background: '.$df_app_sc->app_btn_bkg_color.';">
                    <div title="'.$df_app_sc->app_btn_title.'" class="dfg-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                    <img alt="'.$df_app_sc->app_btn_image_alt_tag.'" class="' . $dfg_shape . '" src="'.$df_app_sc->app_btn_image_upload.'" />
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output3;
		    }
		//button with no icon and no image and no alignment
		 if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload == '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output4 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.'" style="background: '.$df_app_sc->app_btn_bkg_color.';">
                    <div title="'.$df_app_sc->app_btn_title.'"></div>
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output4;
		 }
	}	    	

    //all other buttons with positioning or alignment
    if (  $df_app_sc->app_btn_size == '1col-2row' || $df_app_sc->app_btn_size == '2col-2row' || $df_app_sc->app_btn_size == '3col-2row' || $df_app_sc->app_btn_size == '1col-3row' || $df_app_sc->app_btn_size == '2col-3row' || $df_app_sc->app_btn_size == '3col-3row') {
		//button with icon
		 if ($df_app_sc->app_btn_image_upload == '' && $df_app_sc->app_btn_icon != '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output5 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_position.'" style="background: '.$df_app_sc->app_btn_bkg_color.';">
                    <div title="'.$df_app_sc->app_btn_title.'" class="dfg-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output5;
		 }
		//button with image
		 if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output6 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_position.'" style="background: '.$df_app_sc->app_btn_bkg_color.';">
                    <img alt="'.$df_app_sc->app_btn_image_alt_tag.'" class="'.$df_app_sc->app_btn_shape.'" src="'.$df_app_sc->app_btn_image_upload.'" />
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output6;
		 }
		//button with icon and image
		 if ($df_app_sc->app_btn_icon != '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output7 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_position.'" style="background: '.$df_app_sc->app_btn_bkg_color.';">
                    <div title="'.$df_app_sc->app_btn_title.'" class="dfg-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                    <img alt="'.$df_app_sc->app_btn_image_alt_tag.'" class="' . $dfg_shape . '" src="'.$df_app_sc->app_btn_image_upload.'" />
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output7;
		 }
		//button with no icon and no image and no alignment
		 if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload == '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output12 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.'" style="background: '.$df_app_sc->app_btn_bkg_color.';">
                    <div title="'.$df_app_sc->app_btn_title.'"></div>
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output12;
		 }
	}
}	
	
	
	
if ($df_app_sc->app_btn_bkg_color4 != '') {  	
	//single row button
	if ($df_app_sc->app_btn_size == '1col-1row' || $df_app_sc->app_btn_size == '2col-1row' || $df_app_sc->app_btn_size == '3col-1row' || $df_app_sc->app_btn_size == '4col-1row' || $df_app_sc->app_btn_size == '4col-2row' || $df_app_sc->app_btn_size == '4col-3row') {
		   //button with icon and no alignment
		    if ($df_app_sc->app_btn_image_upload == '' && $df_app_sc->app_btn_icon != '' && $df_app_sc->df_app_oxy == 'No') {    		
			$df_app_sc_output20 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.'" style="background: '.$df_app_sc->app_btn_bkg_color4.';">
                    <div title="'.$df_app_sc->app_btn_title.'" class="dfg-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
            echo $df_app_sc_output20;
		    }
		 //button with image and no alignment 
		 if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output19 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.'" style="background: '.$df_app_sc->app_btn_bkg_color4.';">
                    <img alt="'.$df_app_sc->app_btn_image_alt_tag.'" class="'.$df_app_sc->app_btn_shape.'" src="'.$df_app_sc->app_btn_image_upload.'" />
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output19;
		    }
		 //button with icon and image and no alignment
		  if ($df_app_sc->app_btn_icon != '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output18 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.'" style="background: '.$df_app_sc->app_btn_bkg_color4.';">
                    <div title="'.$df_app_sc->app_btn_title.'" class="dfg-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                    <img alt="'.$df_app_sc->app_btn_image_alt_tag.'" class="' . $dfg_shape . '" src="'.$df_app_sc->app_btn_image_upload.'" />
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output18;
		    }
		//button with no icon and no image and no alignment
		 if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload == '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output17 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.'" style="background: '.$df_app_sc->app_btn_bkg_color4.';">
                    <div title="'.$df_app_sc->app_btn_title.'"></div>
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output17;
		 }
	}	    	

    //all other buttons with positioning or alignment
    if (  $df_app_sc->app_btn_size == '1col-2row' || $df_app_sc->app_btn_size == '2col-2row' || $df_app_sc->app_btn_size == '3col-2row' || $df_app_sc->app_btn_size == '1col-3row' || $df_app_sc->app_btn_size == '2col-3row' || $df_app_sc->app_btn_size == '3col-3row') {
		//button with icon
		 if ($df_app_sc->app_btn_image_upload == '' && $df_app_sc->app_btn_icon != '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output16 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_position.'" style="background: '.$df_app_sc->app_btn_bkg_color4.';">
                    <div title="'.$df_app_sc->app_btn_title.'" class="dfg-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output16;
		 }
		//button with image
		 if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output15 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_position.'" style="background: '.$df_app_sc->app_btn_bkg_color4.';">
                    <img alt="'.$df_app_sc->app_btn_image_alt_tag.'" class="'.$df_app_sc->app_btn_shape.'" src="'.$df_app_sc->app_btn_image_upload.'" />
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output15;
		 }
		//button with icon and image
		 if ($df_app_sc->app_btn_icon != '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output14 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_position.'" style="background: '.$df_app_sc->app_btn_bkg_color4.';">
                    <div title="'.$df_app_sc->app_btn_title.'" class="dfg-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                    <img alt="'.$df_app_sc->app_btn_image_alt_tag.'" class="' . $dfg_shape . '" src="'.$df_app_sc->app_btn_image_upload.'" />
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output14;
		 }
		//button with no icon and no image and no alignment
		 if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload == '' && $df_app_sc->df_app_oxy == 'No') {
			$df_app_sc_output13 = '<a title="'.$df_app_sc->app_btn_link_alt_tag.'" href="'.$df_app_sc->app_btn_link.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="dfg-item '.$df_app_sc->app_btn_shape.' dfg-'.$df_app_sc->app_btn_size.'" style="background: '.$df_app_sc->app_btn_bkg_color4.';">
                    <div title="'.$df_app_sc->app_btn_title.'"></div>
                    <div class="dfg-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
            </a>';
		    echo $df_app_sc_output13;
		 }
	}
}	
	


	//display logo
    if (  $df_app_sc->app_btn_title == 'Logo' && $df_app_sc->df_app_oxy == 'No') {
		//square logo element
		 if ($df_app_sc->app_btn_size == 'dfg-logo') {
		     $df_app_sc_output8 = '<div class="dfg-item logo '.$df_app_sc->app_btn_size.'"><img alt="'.$df_app_sc->app_btn_image_alt_tag.'" class="'.$df_app_sc->app_btn_shape.'" src="'.$df_app_sc->app_btn_image_upload.'" /></div>';
		     echo $df_app_sc_output8;
		 }
		//rectangle and tall logo element
		 if ($df_app_sc->app_btn_size == 'dfg-2col-2row' || $df_app_sc->app_btn_size == 'dfg-2col-3row' ) {
		     $df_app_sc_output9 = '<div class="dfg-item logo '.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_position.'"><img alt="'.$df_app_sc->app_btn_image_alt_tag.'" class="'.$df_app_sc->app_btn_shape.'" src="'.$df_app_sc->app_btn_image_upload.'" /></div>';
		     echo $df_app_sc_output9;
		 }
    }
	
	//display LayerSlider
    if (  $df_app_sc->app_btn_title == 'LayerSlider' && $df_app_sc->df_app_oxy == 'No') {
        $df_ls_no = $df_app_sc->app_btn_link;
        echo '<div class="dfg-item dfg-slider">';
        echo ''.layerslider( $df_ls_no ) .'';
        echo '</div>';
    }
 
	//display Vimeo Video element
    if ($df_app_sc->app_btn_title == 'Vimeo Video' && $df_app_sc->df_app_oxy == 'No') {
        $df_vimeo_video_sc = $df_app_sc->app_btn_link;
		    if ($df_app_sc->app_btn_size == 'dfgv-video') {
		        $df_app_sc_output10 = '<div class="dfg-item embed-container dfgv-video"><iframe src="https://player.vimeo.com/video/'.$df_vimeo_video_sc.'" width="640" height="360" frameborder="0" allow="autoplay; fullscreen" allowfullscreen></iframe></div>';
		        echo $df_app_sc_output10;
            }
		    if ($df_app_sc->app_btn_size == 'dfgv-2col-2row') {
		        $df_app_sc_output11 = '<div style="background: #000000;" class="dfg-item embed-container-sq dfgv-2col-2row '.$df_app_sc->app_btn_position.'"><iframe src="https://player.vimeo.com/video/'.$df_vimeo_video_sc.'" width="640" height="360" frameborder="0" allow="autoplay; fullscreen" allowfullscreen></iframe></div>';
                echo $df_app_sc_output11;
		    }
    }  
    
  
    
if ($df_app_sc->app_btn_bkg_color4 == '') { 
    //single row button
    if ($df_app_sc->app_btn_size == '1col-1row' || $df_app_sc->app_btn_size == '2col-1row' || $df_app_sc->app_btn_size == '3col-1row' || $df_app_sc->app_btn_size == '4col-1row' ||  $df_app_sc->app_btn_size == '1col-2row' || $df_app_sc->app_btn_size == '2col-2row' || $df_app_sc->app_btn_size == '3col-2row' || $df_app_sc->app_btn_size == '4col-2row' || $df_app_sc->app_btn_size == '1col-3row' ||  $df_app_sc->app_btn_size == '2col-3row' || $df_app_sc->app_btn_size == '3col-3row' || $df_app_sc->app_btn_size == '4col-3row') {
           //button with icon
            if ($df_app_sc->app_btn_image_upload == '' && $df_app_sc->app_btn_icon != '' && $df_app_sc->df_app_oxy == 'Yes') {           
            $df_app_sc_output1 = '<div class="dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_shape.'" style="background-color: '.$df_app_sc->app_btn_bkg_color.';">
            <div class="content">
                <a class="item-link" href="'.$df_app_sc->app_btn_link.'" title="'.$df_app_sc->app_btn_link_alt_tag.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="content-icon">
                    <div class="item-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            echo $df_app_sc_output1;
            }
         //button with image
         if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'Yes') {
            $df_app_sc_output2 = '<div class="dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_shape.'" style="background-color: '.$df_app_sc->app_btn_bkg_color.';">
            <div class="content">
                <a class="item-link" href="'.$df_app_sc->app_btn_link.'" title="'.$df_app_sc->app_btn_link_alt_tag.'" target="'.$df_app_sc->app_btn_link_target.'">
                <img class="item-image '.$df_app_sc->app_btn_shape.'" alt="'.$df_app_sc->app_btn_image_alt_tag.'" src="'.$df_app_sc->app_btn_image_upload.'">
                <div class="content-icon">
                    <div class="item-icon"></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            echo $df_app_sc_output2;
            }
         //button with icon and image
          if ($df_app_sc->app_btn_icon != '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'Yes') {
            $df_app_sc_output3 = '<div class="dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_shape.'" style="background-color: '.$df_app_sc->app_btn_bkg_color.';">
            <div class="content">
                <a class="item-link" href="'.$df_app_sc->app_btn_link.'" title="'.$df_app_sc->app_btn_link_alt_tag.'" target="'.$df_app_sc->app_btn_link_target.'">
                <img class="item-image '.$df_app_sc->app_btn_shape.'" alt="'.$df_app_sc->app_btn_image_alt_tag.'" src="'.$df_app_sc->app_btn_image_upload.'">
                <div class="content-icon">
                    <div class="item-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            echo $df_app_sc_output3;
            }
        //button with no icon and no image
         if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload == '' && $df_app_sc->df_app_oxy == 'Yes') {
            $df_app_sc_output4 = '<div class="dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_shape.'" style="background-color: '.$df_app_sc->app_btn_bkg_color.';">
            <div class="content">
                <a class="item-link" href="'.$df_app_sc->app_btn_link.'" title="'.$df_app_sc->app_btn_link_alt_tag.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="content-icon">
                    <div class="item-icon"></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            echo $df_app_sc_output4;
         }
    }
}   
    
if ($df_app_sc->app_btn_bkg_color4 != '') { 
    //single row button
    if ($df_app_sc->app_btn_size == '1col-1row' || $df_app_sc->app_btn_size == '2col-1row' || $df_app_sc->app_btn_size == '3col-1row' || $df_app_sc->app_btn_size == '4col-1row' ||  $df_app_sc->app_btn_size == '1col-2row' || $df_app_sc->app_btn_size == '2col-2row' || $df_app_sc->app_btn_size == '3col-2row' || $df_app_sc->app_btn_size == '4col-2row' || $df_app_sc->app_btn_size == '1col-3row' ||  $df_app_sc->app_btn_size == '2col-3row' || $df_app_sc->app_btn_size == '3col-3row' || $df_app_sc->app_btn_size == '4col-3row') {
           //button with icon
            if ($df_app_sc->app_btn_image_upload == '' && $df_app_sc->app_btn_icon != '' && $df_app_sc->df_app_oxy == 'Yes') {           
            $df_app_sc_output1 = '<div class="dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_shape.'" style="background-color: '.$df_app_sc->app_btn_bkg_color4.';">
            <div class="content">
                <a class="item-link" href="'.$df_app_sc->app_btn_link.'" title="'.$df_app_sc->app_btn_link_alt_tag.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="content-icon">
                    <div class="item-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            echo $df_app_sc_output1;
            }
         //button with image
         if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'Yes') {
            $df_app_sc_output2 = '<div class="dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_shape.'" style="background-color: '.$df_app_sc->app_btn_bkg_color4.';">
            <div class="content">
                <a class="item-link" href="'.$df_app_sc->app_btn_link.'" title="'.$df_app_sc->app_btn_link_alt_tag.'" target="'.$df_app_sc->app_btn_link_target.'">
                <img class="item-image '.$df_app_sc->app_btn_shape.'" alt="'.$df_app_sc->app_btn_image_alt_tag.'" src="'.$df_app_sc->app_btn_image_upload.'">
                <div class="content-icon">
                    <div class="item-icon"></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            echo $df_app_sc_output2;
            }
         //button with icon and image
          if ($df_app_sc->app_btn_icon != '' && $df_app_sc->app_btn_image_upload != '' && $df_app_sc->df_app_oxy == 'Yes') {
            $df_app_sc_output3 = '<div class="dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_shape.'" style="background-color: '.$df_app_sc->app_btn_bkg_color4.';">
            <div class="content">
                <a class="item-link" href="'.$df_app_sc->app_btn_link.'" title="'.$df_app_sc->app_btn_link_alt_tag.'" target="'.$df_app_sc->app_btn_link_target.'">
                <img class="item-image '.$df_app_sc->app_btn_shape.'" alt="'.$df_app_sc->app_btn_image_alt_tag.'" src="'.$df_app_sc->app_btn_image_upload.'">
                <div class="content-icon">
                    <div class="item-icon" style="color: '.$df_app_sc->app_btn_icon_color.';"><i class="'.$df_app_sc->app_btn_icon_weight.' '.$df_app_sc->app_btn_icon.'"></i></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            echo $df_app_sc_output3;
            }
        //button with no icon and no image
         if ($df_app_sc->app_btn_icon == '' && $df_app_sc->app_btn_image_upload == '' && $df_app_sc->df_app_oxy == 'Yes') {
            $df_app_sc_output4 = '<div class="dfg-'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_shape.'" style="background-color: '.$df_app_sc->app_btn_bkg_color4.';">
            <div class="content">
                <a class="item-link" href="'.$df_app_sc->app_btn_link.'" title="'.$df_app_sc->app_btn_link_alt_tag.'" target="'.$df_app_sc->app_btn_link_target.'">
                <div class="content-icon">
                    <div class="item-icon"></div>
                </div>
                <div class="content-title">
                    <div class="item-title" style="color: '.$df_app_sc->app_btn_title_color.';">'.$df_app_sc->app_btn_title.'</div>
                </div>
                </a>
            </div>
                </div>';
            echo $df_app_sc_output4;
         }
    }
}     
    
    


    //display logo
    if (  $df_app_sc->app_btn_title == 'Logo' && $df_app_sc->df_app_oxy == 'Yes') {
        //square logo element
         if ($df_app_sc->app_btn_size == 'dfg-logo') {
             $df_app_sc_output9 = '
       <div class="'.$df_app_sc->app_btn_size.'">
           <img class="item-logo-image '.$df_app_sc->app_btn_shape.'" alt="'.$df_app_sc->app_btn_image_alt_tag.'" src="'.$df_app_sc->app_btn_image_upload.'">  
       </div>';
             echo $df_app_sc_output9;
         }
        //rectangle and tall logo element
         if ($df_app_sc->app_btn_size == 'dfg-2col-2row' || $df_app_sc->app_btn_size == 'dfg-2col-3row' ) {
             $df_app_sc_output10 = '<div class="'.$df_app_sc->app_btn_size.' '.$df_app_sc->app_btn_shape.'">
            <div class="content">
                <img class="item-image '.$df_app_sc->app_btn_shape.'" alt="'.$df_app_sc->app_btn_image_alt_tag.'" src="'.$df_app_sc->app_btn_image_upload.'">
                <div class="content-icon">
                    <div class="item-icon"></div>
                </div>
                <div class="content-title">
                    <div class="item-title"></div>
                </div>
            </div>
                </div>';
             echo $df_app_sc_output10;
         }
    }
    
    //display Slider or Video
    if (  $df_app_sc->app_btn_title == 'LayerSlider' && $df_app_sc->df_app_oxy == 'Yes') {
        $df_ls_no = $df_app_sc->app_btn_link;
        $oxy_slider = do_shortcode( '[oxygen-template id="'. $df_ls_no . '"]' );
        echo '<div class="dfg-4col-2row">
            <div class="content-video">
                <div class="item-video">';
        echo $oxy_slider;
        echo '</div>
            </div>
       </div>';
    }    
    
	//display Vimeo Video element
    if ($df_app_sc->app_btn_title == 'Vimeo Video' && $df_app_sc->df_app_oxy == 'Yes') {
        $df_vimeo_video_sc = $df_app_sc->app_btn_link;
		    if ($df_app_sc->app_btn_size == 'dfgv-video') {
		        $df_app_sc_output11 = '<div class="dfg-4col-2row">
	   		<div class="content-video">
				<div class="embed-container">
					<iframe src="https://player.vimeo.com/video/'.$df_vimeo_video_sc.'" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
				</div>
	   		</div>
	   		</div>';
		        echo $df_app_sc_output11;     
            }
		    if ($df_app_sc->app_btn_size == 'dfgv-2col-2row' && $df_app_sc->df_app_oxy == 'Yes') {
		        $df_app_sc_output12 = '<div class="dfg-2col-2row" style="background-color: #000000;">
	   		<div class="content-video">
				<div class="embed-container">
					<iframe src="https://player.vimeo.com/video/'.$df_vimeo_video_sc.'" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
				</div>
	   		</div>
	   		</div>';
                echo $df_app_sc_output12;
		    }
}

//enqueue app builder interface output css for x theme
if ($df_app_sc->df_app_oxy == 'No') {
    wp_enqueue_style( 'df_app_builder_css_output', plugins_url('df-app-builder-output.css', __FILE__) );
}

//enqueue flowtype script
if ($df_app_sc->df_app_oxy == 'No') {
    wp_enqueue_script( 'df_app_builder_flowtype', plugins_url( 'flowtype.js', __FILE__), array('jquery'), '1.0', true );
}

//enqueue app builder interface output css for oxygen
if ($df_app_sc->df_app_oxy == 'Yes') {
    wp_enqueue_style( 'df_app_builder_css_output_oxy', plugins_url('df-app-builder-output-oxy.css', __FILE__) );
}
		

		}
	}
	   //end app output
		    echo '</div>';
		    echo '</div>';

}
add_shortcode( 'df-app', 'df_app_builder_output_sc' );

?>