<?php
/*
Plugin Name: Before and After Slide
Plugin URI:  https://www.dentalfone.com/
Description: Reveal beautiful smiles!
Version:     1.0
Author:      Dentalfone
Author URI:  https://www.dentalfone.com/
Text Domain: Before and After Slide
*/

add_shortcode( 'before_after', 'baslide');
function baslide( $attr, $bacontent ) {
  if (!isset($attr['imgb'])) $attr['imgb'] = '';
  if (!isset($attr['imga'])) $attr['imga'] = '';
  if (!isset($attr['imgb'])) $attr['altb'] = '';
  if (!isset($attr['imga'])) $attr['alta'] = '';
  $baslide_string .= '<div class="ba-slide">';
  $baslide_string .= '<div class="ba-label-after">After</div>';
  $baslide_string .= '<img src="' . $attr['imga'] .'" alt="' . $attr['alta'] .'">';
  $baslide_string .= '<div class="resize">';
  $baslide_string .= '<div class="ba-label-before">Before</div>';
  $baslide_string .= '<img src="' . $attr['imgb'] .'" alt="' . $attr['altb'] .'">';
  $baslide_string .= '</div>';
  $baslide_string .= '<span class="handle"></span>';
  $baslide_string .= '</div>';
  $baslide_string .= do_shortcode($bacontent);
  return $baslide_string;
}

add_action( 'wp_enqueue_scripts', 'baslide_scripts');
function baslide_scripts (){
  $plugin_url = plugins_url( '/', __FILE__ );
  wp_enqueue_style (
    'baslide-style',
    $plugin_url . 'baslide-style.css'
  );
  wp_enqueue_script (
    'baslide-script',
    $plugin_url . 'baslide-script.js',
    array( 'jquery' ),
    '1.0.1',
    true
  );
}

add_action('wp_footer', 'baslide_scripts');
?>